<?php
/**
 * Organica functions and definitions
 */

/**
* Require files
*/
	//TGM-Plugin-Activation
require_once( get_template_directory().'/class-tgm-plugin-activation.php' );
	//Init the Redux Framework
if ( class_exists( 'ReduxFramework' ) && !isset( $redux_demo ) && file_exists( get_template_directory().'/theme-config.php' ) ) {
	require_once( get_template_directory().'/theme-config.php' );
}
	// Theme files
if ( !class_exists( 'roadthemes_widgets' ) && file_exists( get_template_directory().'/include/roadthemeswidgets.php' ) ) {
	require_once( get_template_directory().'/include/organicawidgets.php' );
}
if ( file_exists( get_template_directory().'/include/styleswitcher.php' ) ) {
	require_once( get_template_directory().'/include/styleswitcher.php' );
}
if ( file_exists( get_template_directory().'/include/wooajax.php' ) ) {
	require_once( get_template_directory().'/include/wooajax.php' );
}
if ( file_exists( get_template_directory().'/include/map_shortcodes.php' ) ) {
	require_once( get_template_directory().'/include/map_shortcodes.php' );
}
if ( file_exists( get_template_directory().'/include/shortcodes.php' ) ) {
	require_once( get_template_directory().'/include/shortcodes.php' );
}
if ( file_exists( get_template_directory().'/include/blogsharing.php' ) ) {
	require_once( get_template_directory().'/include/blogsharing.php' );
}
if ( file_exists( get_template_directory().'/include/productsharing.php' ) ) {
	require_once( get_template_directory().'/include/productsharing.php' );
}
if ( file_exists( ABSPATH . 'wp-admin/includes/file.php' ) ) {
	require_once(ABSPATH . 'wp-admin/includes/file.php');
}

define('PLUGIN_REQUIRED_PATH','http://roadthemes.com/plugins');

Class Organica_Class {
	
	/**
	* Global values
	*/
	static function organica_post_odd_event(){
		if(!session_id()) {
			session_start();
		}
		if(!isset($_SESSION["organica_postcount"])){
			$_SESSION["organica_postcount"] = 0;
		}
		
		$_SESSION["organica_postcount"] = 1 - $_SESSION["organica_postcount"];
		
		return $_SESSION["organica_postcount"];
	}
	static function organica_post_thumbnail_size($size){
		if(!session_id()) {
			session_start();
		}
		if($size!=''){
			$_SESSION["organica_postthumb"] = $size;
		}
		
		return $_SESSION["organica_postthumb"];
	}
	static function organica_shop_class($class){
		if(!session_id()) {
			session_start();
		}
		if($class!=''){
			$_SESSION["organica_shopclass"] = $class;
		}
		
		return $_SESSION["organica_shopclass"];
	}
	static function organica_show_view_mode(){

		$organica_opt = get_option( 'organica_opt' );
		
		$organica_viewmode = 'grid-view'; //default value
		
		if(isset($organica_opt['default_view'])) {
			$organica_viewmode = $organica_opt['default_view'];
		}
		if(isset($_GET['view']) && $_GET['view']!=''){
			$organica_viewmode = $_GET['view'];
		}
		
		return $organica_viewmode;
	}
	static function organica_shortcode_products_count(){
		if(!session_id()) {
			session_start();
		}
		$organica_productsfound = 0;
		if(isset($_SESSION["organica_productsfound"])){
			$organica_productsfound = $_SESSION["organica_productsfound"];
		}
		
		return $organica_productsfound;
	}
	
	/**
	* Constructor
	*/
	function __construct() {
		// Register action/filter callbacks
		
			//WooCommerce - action/filter
		add_theme_support( 'woocommerce' );
		remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
		remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
		add_filter( 'get_product_search_form', array($this, 'organica_woo_search_form'));
		add_filter( 'woocommerce_shortcode_products_query', array($this, 'organica_woocommerce_shortcode_count'));
		add_action( 'woocommerce_share', array($this, 'organica_woocommerce_social_share'), 35 );
		add_action( 'woocommerce_archive_description', array($this, 'organica_woocommerce_category_image'), 2 );
		
			//move message to top
		remove_action( 'woocommerce_before_shop_loop', 'wc_print_notices', 10 );
		add_action( 'woocommerce_show_message', 'wc_print_notices', 10 );

			//remove cart total under cross sell
		remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals', 10 );

		//remove add to cart button after item
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
		
			//Single product organize
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 15 );
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 15 );
		
		
			//WooProjects - Project organize
		remove_action( 'projects_before_single_project_summary', 'projects_template_single_title', 10 );
		add_action( 'projects_single_project_summary', 'projects_template_single_title', 5 );
		remove_action( 'projects_before_single_project_summary', 'projects_template_single_short_description', 20 );
		remove_action( 'projects_before_single_project_summary', 'projects_template_single_gallery', 40 );
		add_action( 'projects_single_project_gallery', 'projects_template_single_gallery', 40 );
		
			//WooProjects - projects list
		remove_action( 'projects_loop_item', 'projects_template_loop_project_title', 20 );
		
			//Theme actions
		add_action( 'after_setup_theme', array($this, 'organica_setup'));
		add_action( 'tgmpa_register', array($this, 'organica_register_required_plugins')); 
		add_action( 'widgets_init', array($this, 'organica_override_woocommerce_widgets'), 15 );
		
		add_action( 'wp_enqueue_scripts', array($this, 'organica_scripts_styles') );
		add_action( 'wp_head', array($this, 'organica_custom_code_header'));
		add_action( 'wp_head', array($this, 'organica_custom_css_header_footer'));
		add_action( 'widgets_init', array($this, 'organica_widgets_init'));
		add_action( 'add_meta_boxes', array($this, 'organica_add_meta_box'));
		add_action( 'save_post', array($this, 'organica_save_meta_box_data'));
		add_action('comment_form_before_fields', array($this, 'organica_before_comment_fields'));
		add_action('comment_form_after_fields', array($this, 'organica_after_comment_fields'));
		add_action( 'customize_register', array($this, 'organica_customize_register'));
		add_action( 'customize_preview_init', array($this, 'organica_customize_preview_js'));
		add_action( 'admin_head', array($this, 'organica_remove_redux_ads'));
		
			//Theme filters
		//add_filter( 'woocommerce_get_price_html', array($this, 'organica_woo_price_html'), 100, 2 );
		add_filter( 'loop_shop_per_page', array($this, 'organica_woo_change_per_page'), 20 );
		add_filter( 'woocommerce_output_related_products_args', array($this, 'organica_woo_related_products_limit'));
		add_filter( 'get_search_form', array($this, 'organica_search_form'));
		add_filter('excerpt_more', array($this, 'organica_new_excerpt_more'));
		add_filter( 'excerpt_length', array($this, 'organica_change_excerpt_length'), 999 );
		add_filter('wp_nav_menu_objects', array($this, 'organica_first_and_last_menu_class'));
		add_filter( 'wp_page_menu_args', array($this, 'organica_page_menu_args'));
		add_filter('dynamic_sidebar_params', array($this, 'organica_widget_first_last_class'));
		add_filter('dynamic_sidebar_params', array($this, 'organica_mega_menu_widget_change'));
		add_filter( 'dynamic_sidebar_params', array($this, 'organica_put_widget_content'));
		
		//Adding theme support
		if ( ! isset( $content_width ) ) {
			$content_width = 625;
		}
	}
	
	/**
	* Filter callbacks
	* ----------------
	*/
	//Change price html
	function organica_woo_price_html( $price, $product ){

		if($product->get_type()=="variable") {
			if($product->get_variation_sale_price() && $product->get_variation_regular_price()!=$product->get_variation_sale_price()){
				$rprice = $product->get_variation_regular_price();
				$sprice = $product->get_variation_sale_price();
				
				return '<span class="special-price">'.( ( is_numeric( $sprice ) ) ? wc_price( $sprice ) : $sprice ) .'</span><span class="old-price">'. ( ( is_numeric( $rprice ) ) ? wc_price( $rprice ) : $rprice ) .'</span>'.$product->get_price_suffix();
			} else {
				$rprice = $product->get_variation_regular_price();
				return '<span class="special-price">' . ( ( is_numeric( $rprice ) ) ? wc_price( $rprice ) : $rprice ) . '</span>'.$product->get_price_suffix();
			}
		}
		if ( $product->get_price() > 0 ) {
			if ( $product->get_price() && isset($product->regular_price) && ( $product->get_price() != $product->get_regular_price() )) {
			$rprice = $product->get_regular_price();
			$sprice = $product->get_price();
			return '<span class="special-price">'.( ( is_numeric( $sprice ) ) ? wc_price( $sprice ) : $sprice ) .'</span><span class="old-price">'. ( ( is_numeric( $rprice ) ) ? wc_price( $rprice ) : $rprice ) .'</span>'.$product->get_price_suffix();
			} else {
			$sprice = $product->get_price();
			return '<span class="special-price">' . ( ( is_numeric( $sprice ) ) ? wc_price( $sprice ) : $sprice ) . '</span>'.$product->get_price_suffix();
			}
		} else {
			return '<span class="special-price">0</span>'.$product->get_price_suffix();
		}
	}
	// Change products per page
	function organica_woo_change_per_page() {
		$organica_opt = get_option( 'organica_opt' );
		
		return $organica_opt['product_per_page'];
	}
	//Change number of related products on product page. Set your own value for 'posts_per_page'
	function organica_woo_related_products_limit( $args ) {
		global $product;

		$organica_opt = get_option( 'organica_opt' );

		$args['posts_per_page'] = $organica_opt['related_amount'];

		return $args;
	}
	// Count number of products from shortcode
	function organica_woocommerce_shortcode_count( $args ) {
		$organica_productsfound = new WP_Query($args);
		$organica_productsfound = $organica_productsfound->post_count;
		
		if(!session_id()) {
			session_start();
		}
		$_SESSION["organica_productsfound"] = $organica_productsfound;
		
		return $args;
	}
	//Change search form
	function organica_search_form( $form ) {
		if(get_search_query()!=''){
			$search_str = get_search_query();
		} else {
			$search_str = __( 'Search...', 'organica' );
		}
		
		$form = '<form role="search" method="get" id="blogsearchform" class="searchform" action="' . esc_url(home_url( '/' ) ). '" >
		<div class="form-input">
			<input class="input_text" type="text" value="'.esc_attr($search_str).'" name="s" id="search_input" />
			<button class="button" type="submit" id="blogsearchsubmit"><i class="fa fa-search"></i></button>
			</div>
		</form>';
		$form .= '<script type="text/javascript">';
		$form .= 'jQuery(document).ready(function(){
			jQuery("#search_input").focus(function(){
				if(jQuery(this).val()=="'.__( 'Search...', 'organica' ).'"){
					jQuery(this).val("");
				}
			});
			jQuery("#search_input").focusout(function(){
				if(jQuery(this).val()==""){
					jQuery(this).val("'.__( 'Search...', 'organica' ).'");
				}
			});
			jQuery("#blogsearchsubmit").click(function(){
				if(jQuery("#search_input").val()=="'.__( 'Search...', 'organica' ).'" || jQuery("#search_input").val()==""){
					jQuery("#search_input").focus();
					return false;
				}
			});
		});';
		$form .= '</script>';
		return $form;
	}
	//Change woocommerce search form
	function organica_woo_search_form( $form ) {
		global $wpdb;
		
		if(get_search_query()!=''){
			$search_str = get_search_query();
		} else {
			$search_str = __( 'Search product...', 'organica' );
		}
		
		$form = '<form role="search" method="get" id="searchform" action="'.esc_url( home_url( '/'  ) ).'">';
			$form .= '<div class="form-input">';
				$form .= '<input type="text" value="'.esc_attr($search_str).'" name="s" id="ws" placeholder="" />';
				$form .= '<button class="btn btn-primary" type="submit" id="wsearchsubmit"><i class="fa fa-search"></i></button>';
				$form .= '<input type="hidden" name="post_type" value="product" />';
			$form .= '</div>';
		$form .= '</form>';
		$form .= '<script type="text/javascript">';
		$form .= 'jQuery(document).ready(function(){
			jQuery("#ws").focus(function(){
				if(jQuery(this).val()=="'.__( 'Search product...', 'organica' ).'"){
					jQuery(this).val("");
				}
			});
			jQuery("#ws").focusout(function(){
				if(jQuery(this).val()==""){
					jQuery(this).val("'.__( 'Search product...', 'organica' ).'");
				}
			});
			jQuery("#wsearchsubmit").click(function(){
				if(jQuery("#ws").val()=="'.__( 'Search product...', 'organica' ).'" || jQuery("#ws").val()==""){
					jQuery("#ws").focus();
					return false;
				}
			});
		});';
		$form .= '</script>';
		return $form;
	}
	// Replaces the excerpt "more" text by a link
	function organica_new_excerpt_more($more) {
		return '';
	}
	//Change excerpt length
	function organica_change_excerpt_length( $length ) {
		$organica_opt = get_option( 'organica_opt' );
		
		if(isset($organica_opt['excerpt_length'])){
			return $organica_opt['excerpt_length'];
		}
		
		return 22;
	}
	//Add 'first, last' class to menu
	function organica_first_and_last_menu_class($items) {
		$items[1]->classes[] = 'first';
		$items[count($items)]->classes[] = 'last';
		return $items;
	}
	/**
	 * Filter the page menu arguments.
	 *
	 * Makes our wp_nav_menu() fallback -- wp_page_menu() -- show a home link.
	 *
	 * @since Huge Shop 1.0
	 */
	function organica_page_menu_args( $args ) {
		if ( ! isset( $args['show_home'] ) )
			$args['show_home'] = true;
		return $args;
	}
	//Add first, last class to widgets
	function organica_widget_first_last_class($params) {
		global $my_widget_num;
		
		$class = '';
		
		$this_id = $params[0]['id']; // Get the id for the current sidebar we're processing
		$arr_registered_widgets = wp_get_sidebars_widgets(); // Get an array of ALL registered widgets	

		if(!$my_widget_num) {// If the counter array doesn't exist, create it
			$my_widget_num = array();
		}

		if(!isset($arr_registered_widgets[$this_id]) || !is_array($arr_registered_widgets[$this_id])) { // Check if the current sidebar has no widgets
			return $params; // No widgets in this sidebar... bail early.
		}

		if(isset($my_widget_num[$this_id])) { // See if the counter array has an entry for this sidebar
			$my_widget_num[$this_id] ++;
		} else { // If not, create it starting with 1
			$my_widget_num[$this_id] = 1;
		}

		if($my_widget_num[$this_id] == 1) { // If this is the first widget
			$class .= ' widget-first ';
		} elseif($my_widget_num[$this_id] == count($arr_registered_widgets[$this_id])) { // If this is the last widget
			$class .= ' widget-last ';
		}
		
		$params[0]['before_widget'] = str_replace('first_last', ' '.$class.' ', $params[0]['before_widget']);
		
		return $params;
	}
	//Change mega menu widget from div to li tag
	function organica_mega_menu_widget_change($params) {
		
		$sidebar_id = $params[0]['id'];
		
		$pos = strpos($sidebar_id, '_menu_widgets_area_');
		
		if ( !$pos == false ) {
			$params[0]['before_widget'] = '<li class="widget_mega_menu">'.$params[0]['before_widget'];
			$params[0]['after_widget'] = $params[0]['after_widget'].'</li>';
		}
		
		return $params;
	}
	// Push sidebar widget content into a div
	function organica_put_widget_content( $params ) {
		global $wp_registered_widgets;

		if( $params[0]['id']=='sidebar-category' ){
			$settings_getter = $wp_registered_widgets[ $params[0]['widget_id'] ]['callback'][0];
			$settings = $settings_getter->get_settings();
			$settings = $settings[ $params[1]['number'] ];
			
			if($params[0]['widget_name']=="Text" && isset($settings['title']) && $settings['text']=="") { // if text widget and no content => don't push content
				return $params;
			}
			if( isset($settings['title']) && $settings['title']!='' ){
				$params[0][ 'after_title' ] .= '<div class="widget_content">';
				$params[0][ 'after_widget' ] = '</div>'.$params[0][ 'after_widget' ];
			} else {
				$params[0][ 'before_widget' ] .= '<div class="widget_content">';
				$params[0][ 'after_widget' ] = '</div>'.$params[0][ 'after_widget' ];
			}
		}
		
		return $params;
	}
	
	/**
	* Action hooks
	* ----------------
	*/
	/**
	 * Huge Shop setup.
	 *
	 * Sets up theme defaults and registers the various WordPress features that
	 * Huge Shop supports.
	 *
	 * @uses load_theme_textdomain() For translation/localization support.
	 * @uses add_editor_style() To add a Visual Editor stylesheet.
	 * @uses add_theme_support() To add support for post thumbnails, automatic feed links,
	 * 	custom background, and post formats.
	 * @uses register_nav_menu() To add support for navigation menus.
	 * @uses set_post_thumbnail_size() To set a custom post thumbnail size.
	 *
	 * @since Huge Shop 1.0
	 */
	function organica_setup() {
		/*
		 * Makes Huge Shop available for translation.
		 *
		 * Translations can be added to the /languages/ directory.
		 * If you're building a theme based on Huge Shop, use a find and replace
		 * to change 'organica' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'organica', get_template_directory() . '/languages' );

		// This theme styles the visual editor with editor-style.css to match the theme style.
		add_editor_style();

		// Adds RSS feed links to <head> for posts and comments.
		add_theme_support( 'automatic-feed-links' );

		// This theme supports a variety of post formats.
		add_theme_support( 'post-formats', array( 'image', 'gallery', 'video', 'audio' ) );

		// Register menus
		register_nav_menu( 'primary', __( 'Primary Menu', 'organica' ) );
		register_nav_menu( 'topmenu', __( 'Top Menu', 'organica' ) );
		register_nav_menu( 'mobilemenu', __( 'Mobile Menu', 'organica' ) );
		register_nav_menu( 'categories', __( 'Categories Menu', 'organica' ) );

		/*
		 * This theme supports custom background color and image,
		 * and here we also set up the default background color.
		 */
		add_theme_support( 'custom-background', array(
			'default-color' => 'e6e6e6',
		) );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );
		
		// This theme uses a custom image size for featured images, displayed on "standard" posts.
		add_theme_support( 'post-thumbnails' );

		set_post_thumbnail_size( 1170, 9999 ); // Unlimited height, soft crop
		add_image_size( 'organica-category-thumb', 1170, 700, true ); // (cropped)
		add_image_size( 'organica-post-thumb', 370, 370, true ); // (cropped)
		add_image_size( 'organica-post-thumbwide', 370, 220, true ); // (cropped)
	}
	//Override woocommerce widgets
	function organica_override_woocommerce_widgets() {
		//Show mini cart on all pages
		if ( class_exists( 'WC_Widget_Cart' ) ) {
			unregister_widget( 'WC_Widget_Cart' ); 
			include_once( get_template_directory().'/woocommerce/class-wc-widget-cart.php' );
			register_widget( 'Custom_WC_Widget_Cart' );
		}
	}
	// Add image to category description
	function organica_woocommerce_category_image() {
		if ( is_product_category() ){
			global $wp_query;
			
			$cat = $wp_query->get_queried_object();
			$thumbnail_id = get_woocommerce_term_meta( $cat->term_id, 'thumbnail_id', true );
			$image = wp_get_attachment_url( $thumbnail_id );
			
			if ( $image ) {
				echo '<p class="category-image-desc"><img src="' . esc_url($image) . '" alt="" /></p>';
			}
		}
	}
	//Display social sharing on product page
	function organica_woocommerce_social_share(){
		$organica_opt = get_option( 'organica_opt' );
	?>
		<?php if ($organica_opt['share_code']!='') { ?>
			<div class="share_buttons">
				<?php 
					echo wp_kses($organica_opt['share_code'], array(
						'div' => array(
							'class' => array()
						),
						'span' => array(
							'class' => array(),
							'displayText' => array()
						),
					));
				?>
			</div>
		<?php } ?>
	<?php
	}
	/**
	 * Enqueue scripts and styles for front-end.
	 *
	 * @since Huge Shop 1.0
	 */
	function organica_scripts_styles() {
		global $wp_styles, $wp_scripts;

		$organica_opt = get_option( 'organica_opt' );
		
		/*
		 * Adds JavaScript to pages with the comment form to support
		 * sites with threaded comments (when in use).
		*/
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
			wp_enqueue_script( 'comment-reply' );
		
		// Add Bootstrap JavaScript
		wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '3.2.0', true );
		
		// Add Slick files
		wp_enqueue_script( 'slick-js', get_template_directory_uri() . '/js/slick/slick.min.js', array('jquery'), '1.6.0', true );
		wp_enqueue_style( 'slick-style', get_template_directory_uri() . '/js/slick/slick.css', array(), '1.6.0' );
		
		// Add Chosen js files
		wp_enqueue_script( 'chosen-js', get_template_directory_uri() . '/js/chosen/chosen.jquery.min.js', array('jquery'), '1.3.0', true );
		wp_enqueue_script( 'chosenproto-js', get_template_directory_uri() . '/js/chosen/chosen.proto.min.js', array('jquery'), '1.3.0', true );
		wp_enqueue_style( 'chosen-style', get_template_directory_uri() . '/js/chosen/chosen.min.css', array(), '1.3.0' );
		
		// Add parallax script files
		
		// Add Fancybox
		wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.pack.js', array('jquery'), '2.1.5', true );
		wp_enqueue_script( 'fancybox-buttons', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-buttons.js', array('jquery'), '1.0.5', true );
		wp_enqueue_script( 'fancybox-media', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-media.js', array('jquery'), '1.0.6', true );
		wp_enqueue_script( 'fancybox-thumbs', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-thumbs.js', array('jquery'), '1.0.7', true );
		wp_enqueue_style( 'fancybox-css', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.css', array(), '2.1.5' );
		wp_enqueue_style( 'fancybox-buttons', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-buttons.css', array(), '1.0.5' );
		wp_enqueue_style( 'fancybox-thumbs', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-thumbs.css', array(), '1.0.7' );
		
		//Superfish
		wp_enqueue_script( 'superfish-js', get_template_directory_uri() . '/js/superfish/superfish.min.js', array('jquery'), '1.3.15', true );
		
		//Add Shuffle js
		wp_enqueue_script( 'modernizr-js', get_template_directory_uri() . '/js/modernizr.custom.min.js', array('jquery'), '2.6.2', true );
		wp_enqueue_script( 'shuffle-js', get_template_directory_uri() . '/js/jquery.shuffle.min.js', array('jquery'), '3.0.0', true );

		//Add mousewheel
		wp_enqueue_script( 'mousewheel-js', get_template_directory_uri() . '/js/jquery.mousewheel.min.js', array('jquery'), '3.1.12', true );
		
		// Add jQuery countdown file
		wp_enqueue_script( 'countdown-js', get_template_directory_uri() . '/js/jquery.countdown.min.js', array('jquery'), '2.0.4', true );
		
		//Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions.
		wp_enqueue_script( 'html5-js', get_template_directory_uri() . '/js/html5.js', array(), '3.7.0', true );
		$wp_scripts->add_data( 'html5-js', 'conditional', 'lt IE 9' );
		
		// Add jQuery counter files
		wp_enqueue_script( 'waypoints-js', get_template_directory_uri() . '/js/waypoints.min.js', array('jquery'), '1.0', true );
		wp_enqueue_script( 'counterup-js', get_template_directory_uri() . '/js/jquery.counterup.min.js', array('jquery'), '1.0', true );
		
		// Add theme.js file
		wp_enqueue_script( 'theme-js', get_template_directory_uri() . '/js/theme.min.js', array('jquery'), '20140826', true );

		$font_url = $this->organica_get_font_url();
		if ( ! empty( $font_url ) )
			wp_enqueue_style( 'organica-fonts', esc_url_raw( $font_url ), array(), null );

		// Loads our main stylesheet.
		wp_enqueue_style( 'organica-style', get_stylesheet_uri() );
		
		// Mega Main Menu
		wp_enqueue_style( 'megamenu-css', get_template_directory_uri() . '/css/megamenu_style.css', array(), '2.0.4' );
	
		// Load fontawesome css
		wp_enqueue_style( 'fontawesome-css', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '4.2.0' );

		// Load Simple-Line-Icons css
		wp_enqueue_style( 'simple-line-css', get_template_directory_uri() . '/css/simple-line-icons.css', array(), '2.2.2' );
		
		// Load Simple-Line-Icons css
		wp_enqueue_style( 'pe-icon-7-stroke', get_template_directory_uri() . '/css/pe-icon-7-stroke.css', array(), '1.2.0' );
		
		// Load bootstrap css
		wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/css/bootstrap.min.css', array(), '3.2.0' );
		
		// Compile Less to CSS
		$previewpreset = (isset($_REQUEST['preset']) ? $_REQUEST['preset'] : null);
			//get preset from url (only for demo/preview)
		if($previewpreset){
			$_SESSION["preset"] = $previewpreset;
		}
		$presetopt = 1;
		if(!isset($_SESSION["preset"])){
			$_SESSION["preset"] = 1;
		}
		if($_SESSION["preset"] != 1) {
			$presetopt = $_SESSION["preset"];
		} else { /* if no preset varialbe found in url, use from theme options */
			if(isset($organica_opt['preset_option'])){
				$presetopt = $organica_opt['preset_option'];
			}
		}
		if(!isset($presetopt)) $presetopt = 1; /* in case first time install theme, no options found */
		
		if(isset($organica_opt['enable_less'])){
			if($organica_opt['enable_less']){
				$themevariables = array(
					'body_font'=> $organica_opt['bodyfont']['font-family'],
					'text_color'=> $organica_opt['bodyfont']['color'],
					'text_selected_bg' => $organica_opt['text_selected_bg'],
					'text_selected_color' => $organica_opt['text_selected_color'],
					'text_size'=> $organica_opt['bodyfont']['font-size'],
					'border_color'=> $organica_opt['border_color']['border-color'],
					
					'heading_font'=> $organica_opt['headingfont']['font-family'],
					'heading_color'=> $organica_opt['headingfont']['color'],
					'heading_font_weight'=> $organica_opt['headingfont']['font-weight'],
					
					'menu_font'=> $organica_opt['menufont']['font-family'],
					'menu_color'=> $organica_opt['menufont']['color'],
					'menu_font_size'=> $organica_opt['menufont']['font-size'],
					'menu_font_weight'=> $organica_opt['menufont']['font-weight'],
					'sub_menu_bg' => $organica_opt['sub_menu_bg'],
					'sub_menu_color' => $organica_opt['sub_menu_color'],

					'vmenu_font'=> $organica_opt['vmenufont']['font-family'],
					'vmenu_color'=> $organica_opt['vmenufont']['color'],
					'vmenu_font_size'=> $organica_opt['vmenufont']['font-size'],
					'vmenu_font_weight'=> $organica_opt['vmenufont']['font-weight'],
					'vsub_menu_bg' => $organica_opt['vsub_menu_bg'],
					
					'link_color' => $organica_opt['link_color']['regular'],
					'link_hover_color' => $organica_opt['link_color']['hover'],
					'link_active_color' => $organica_opt['link_color']['active'],
					
					'primary_color' => $organica_opt['primary_color'],
					
					'sale_color' => $organica_opt['sale_color'],
					'saletext_color' => $organica_opt['saletext_color'],
					'rate_color' => $organica_opt['rate_color'],

					'topbar_color' => $organica_opt['topbar_color'],
					'topbar_link_color' => $organica_opt['topbar_link_color']['regular'],
					'topbar_link_hover_color' => $organica_opt['topbar_link_color']['hover'],
					'topbar_link_active_color' => $organica_opt['topbar_link_color']['active'],

					'header_color' => $organica_opt['header_color'],
					'header_link_color' => $organica_opt['header_link_color']['regular'],
					'header_link_hover_color' => $organica_opt['header_link_color']['hover'],
					'header_link_active_color' => $organica_opt['header_link_color']['active'],

					'footer_color' => $organica_opt['footer_color'],
					'footer_link_color' => $organica_opt['footer_link_color']['regular'],
					'footer_link_hover_color' => $organica_opt['footer_link_color']['hover'],
					'footer_link_active_color' => $organica_opt['footer_link_color']['active'],
				);
				
				if(isset($organica_opt['header_sticky_bg']['rgba']) && $organica_opt['header_sticky_bg']['rgba']!="") {
					$themevariables['header_sticky_bg'] = $organica_opt['header_sticky_bg']['rgba'];
				} else {
					$themevariables['header_sticky_bg'] = 'transparent';
				}
				switch ($presetopt) {
					case 2:
						
					break;
					case 3:

					break;
					case 4:
					
					break;
					case 5:
						$themevariables['primary_color'] = '#FFB548';
						$themevariables['topbar_color'] = '#5b6e82';
						$themevariables['topbar_link_color'] = '#5b6e82';
						$themevariables['topbar_link_hover_color'] = '#FFB548';
						$themevariables['menu_color'] = '#fff';		
						$themevariables['header_sticky_bg'] = 'rgba(0,0,0,0.95)';			
					break;
					case 6:	
						$themevariables['menu_color'] = '#ffffff';
					break;
				}

				if(function_exists('compileLessFile')){
					compileLessFile('reset.less', 'reset'.$presetopt.'.css', $themevariables);
					compileLessFile('global.less', 'global'.$presetopt.'.css', $themevariables);
					compileLessFile('pages.less', 'pages'.$presetopt.'.css', $themevariables);
					compileLessFile('woocommerce.less', 'woocommerce'.$presetopt.'.css', $themevariables);
					// compileLessFile('portfolio.less', 'portfolio'.$presetopt.'.css', $themevariables);
					compileLessFile('layouts.less', 'layouts'.$presetopt.'.css', $themevariables);
					compileLessFile('responsive.less', 'responsive'.$presetopt.'.css', $themevariables);
					compileLessFile('ie.less', 'ie'.$presetopt.'.css', $themevariables);
				}
			}
		}
		
		// Load main theme css style files
		wp_enqueue_style( 'organicacss-reset', get_template_directory_uri() . '/css/reset'.$presetopt.'.css', array('bootstrap-css'), '1.0.0' );
		wp_enqueue_style( 'organicacss-global', get_template_directory_uri() . '/css/global'.$presetopt.'.css', array('organicacss-reset'), '1.0.0' );
		wp_enqueue_style( 'organicacss-pages', get_template_directory_uri() . '/css/pages'.$presetopt.'.css', array('organicacss-global'), '1.0.0' );
		wp_enqueue_style( 'organicacss-woocommerce', get_template_directory_uri() . '/css/woocommerce'.$presetopt.'.css', array('organicacss-pages'), '1.0.0' );
		// wp_enqueue_style( 'organicacss-portfolio', get_template_directory_uri() . '/css/portfolio'.$presetopt.'.css', array('organicacss-woocommerce'), '1.0.0' );
		// wp_enqueue_style( 'organicacss-layouts', get_template_directory_uri() . '/css/layouts'.$presetopt.'.css', array('organicacss-portfolio'), '1.0.0' );
		wp_enqueue_style( 'organicacss-layouts', get_template_directory_uri() . '/css/layouts'.$presetopt.'.css', array('organicacss-woocommerce'), '1.0.0' );
		wp_enqueue_style( 'organicacss-responsive', get_template_directory_uri() . '/css/responsive'.$presetopt.'.css', array('organicacss-layouts'), '1.0.0' );
		wp_enqueue_style( 'organicacss-custom', get_template_directory_uri() . '/css/opt_css.css', array('organicacss-responsive'), '1.0.0' );
		
		// Loads the Internet Explorer specific stylesheet.
		wp_enqueue_style( 'organicacss-ie', get_template_directory_uri() . '/css/ie'.$presetopt.'.css', array( 'organicacss-style' ), '20121010' );
		$wp_styles->add_data( 'organicacss-ie', 'conditional', 'lte IE 9' );
		
		if ( ! WP_Filesystem() ) {
			$url = wp_nonce_url();
			request_filesystem_credentials($url, '', true, false, null);
		}
		
		global $wp_filesystem;
		//add custom css, sharing code to header
		if($wp_filesystem->exists(get_template_directory(). '/css/opt_css.css')){
			$customcss = $wp_filesystem->get_contents(get_template_directory(). '/css/opt_css.css');
			
			if($customcss!=$organica_opt['custom_css']){ //if new update, write file content
				$wp_filesystem->put_contents(
					get_template_directory(). '/css/opt_css.css',
					$organica_opt['custom_css'],
					FS_CHMOD_FILE // predefined mode settings for WP files
				);
			}
		} else {
			$wp_filesystem->put_contents(
				get_template_directory(). '/css/opt_css.css',
				$organica_opt['custom_css'],
				FS_CHMOD_FILE // predefined mode settings for WP files
			);
		}
		
		if(isset($organica_opt['enable_sswitcher'])){
			if($organica_opt['enable_sswitcher']){
				// Add styleswitcher.js file
				wp_enqueue_script( 'styleswitcher-js', get_template_directory_uri() . '/js/styleswitcher.js', array(), '20140826', true );
				// Load styleswitcher css style
				wp_enqueue_style( 'styleswitcher-css', get_template_directory_uri() . '/css/styleswitcher.css', array(), '1.0.0' );
				// Load scroll bar js
				wp_enqueue_script( 'scrollbar-js', get_template_directory_uri() . '/js/jquery.scrollbar.min.js', array('jquery'), '0.2.8', true );
				wp_enqueue_style( 'scrollbar-css', get_template_directory_uri() . '/css/scrollbar.css', array(), '1.0.0' );
			}
		}
	}
	//add css for footer, header templates
	function organica_custom_css_header_footer() {
		global $organica_opt;
		
		$jscomposer_templates_args = array(
			'orderby'          => 'title',
			'order'            => 'ASC',
			'post_type'        => 'templatera',
			'post_status'      => 'publish',
			'posts_per_page'   => 30,
		);
		$jscomposer_templates = get_posts( $jscomposer_templates_args );

		if(count($jscomposer_templates) > 0) {
			foreach($jscomposer_templates as $jscomposer_template){
				if($jscomposer_template->post_title == $organica_opt['header_layout'] || $jscomposer_template->post_title == $organica_opt['footer_layout']){
					$jscomposer_template_css = get_post_meta ( $jscomposer_template->ID, '_wpb_shortcodes_custom_css', false );
					echo '<style>'.esc_html($jscomposer_template_css[0]).'</style>';
				}
			}
		}
	}
	//add custom css, sharing code to header
	function organica_custom_code_header() {
		global $organica_opt;

		if ( isset($organica_opt['share_head_code']) && $organica_opt['share_head_code']!='') {
			echo wp_kses($organica_opt['share_head_code'], array(
				'script' => array(
					'type' => array(),
					'src' => array(),
					'async' => array()
				),
			));
		} ?>
		<style><?php echo '.wrapper.box-layout, .wrapper.box-layout .container, .wrapper.box-layout .row-container {max-width: '.$organica_opt['box_layout_width'].'px;}'; ?></style>
		<script type="text/javascript">
		var organica_brandnumber = <?php if(isset($organica_opt['brandnumber'])) { echo esc_js($organica_opt['brandnumber']); } else { echo '6'; } ?>,
			organica_brandscrollnumber = <?php if(isset($organica_opt['brandscrollnumber'])) { echo esc_js($organica_opt['brandscrollnumber']); } else { echo '2';} ?>,
			organica_brandpause = <?php if(isset($organica_opt['brandpause'])) { echo esc_js($organica_opt['brandpause']); } else { echo '3000'; } ?>,
			organica_brandanimate = <?php if(isset($organica_opt['brandanimate'])) { echo esc_js($organica_opt['brandanimate']); } else { echo '700';} ?>;
		var organica_brandscroll = 'false';
			<?php if(isset($organica_opt['brandscroll'])){ ?>
				organica_brandscroll = <?php echo esc_js($organica_opt['brandscroll'])==1 ? 'true': 'false'; ?>;
			<?php } ?>
		var organica_categoriesnumber = <?php if(isset($organica_opt['categoriesnumber'])) { echo esc_js($organica_opt['categoriesnumber']); } else { echo '6'; } ?>,
			organica_categoriesscrollnumber = <?php if(isset($organica_opt['categoriesscrollnumber'])) { echo esc_js($organica_opt['categoriesscrollnumber']); } else { echo '2';} ?>,
			organica_categoriespause = <?php if(isset($organica_opt['categoriespause'])) { echo esc_js($organica_opt['categoriespause']); } else { echo '3000'; } ?>,
			organica_categoriesanimate = <?php if(isset($organica_opt['categoriesanimate'])) { echo esc_js($organica_opt['categoriesanimate']); } else { echo '700';} ?>;
		var organica_categoriesscroll = 'false';
			<?php if(isset($organica_opt['categoriesscroll'])){ ?>
				organica_categoriesscroll = <?php echo esc_js($organica_opt['categoriesscroll'])==1 ? 'true': 'false'; ?>;
			<?php } ?>
		var organica_blogpause = <?php if(isset($organica_opt['blogpause'])) { echo esc_js($organica_opt['blogpause']); } else { echo '3000'; } ?>,
			organica_bloganimate = <?php if(isset($organica_opt['bloganimate'])) { echo esc_js($organica_opt['bloganimate']); } else { echo '700'; } ?>;
		var organica_blogscroll = 'false';
			<?php if(isset($organica_opt['blogscroll'])){ ?>
				organica_blogscroll = <?php echo esc_js($organica_opt['blogscroll'])==1 ? 'true': 'false'; ?>;
			<?php } ?>
		var organica_testipause = <?php if(isset($organica_opt['testipause'])) { echo esc_js($organica_opt['testipause']); } else { echo '3000'; } ?>,
			organica_testianimate = <?php if(isset($organica_opt['testianimate'])) { echo esc_js($organica_opt['testianimate']); } else { echo '700'; } ?>;
		var organica_testiscroll = 'false';
			<?php if(isset($organica_opt['testiscroll'])){ ?>
				organica_testiscroll = <?php echo esc_js($organica_opt['testiscroll'])==1 ? 'true': 'false'; ?>;
			<?php } ?>
		var organica_catenumber = <?php if(isset($organica_opt['catenumber'])) { echo esc_js($organica_opt['catenumber']); } else { echo '6'; } ?>,
			organica_catescrollnumber = <?php if(isset($organica_opt['catescrollnumber'])) { echo esc_js($organica_opt['catescrollnumber']); } else { echo '2';} ?>,
			organica_catepause = <?php if(isset($organica_opt['catepause'])) { echo esc_js($organica_opt['catepause']); } else { echo '3000'; } ?>,
			organica_cateanimate = <?php if(isset($organica_opt['cateanimate'])) { echo esc_js($organica_opt['cateanimate']); } else { echo '700';} ?>;
		var organica_catescroll = 'false';
			<?php if(isset($organica_opt['catescroll'])){ ?>
				organica_catescroll = <?php echo esc_js($organica_opt['catescroll'])==1 ? 'true': 'false'; ?>;
			<?php } ?>
		var organica_menu_number = <?php if(isset($organica_opt['categories_menu_items'])) { echo esc_js((int)$organica_opt['categories_menu_items']+1); } else { echo '9';} ?>;
		var organica_sticky_header = 'false';
			<?php if(isset($organica_opt['sticky_header'])){ ?>
				organica_sticky_header = <?php echo esc_js($organica_opt['sticky_header'])==1 ? 'true': 'false'; ?>;
			<?php } ?>
		</script>
		<?php
	}
	/**
	 * Register sidebars.
	 *
	 * Registers our main widget area and the front page widget areas.
	 *
	 * @since Huge Shop 1.0
	 */
	function organica_widgets_init() {
		$organica_opt = get_option( 'organica_opt' );
		
		register_sidebar( array(
			'name' => esc_html__( 'Blog Sidebar', 'organica' ),
			'id' => 'sidebar-1',
			'description' => esc_html__( 'Sidebar on blog page', 'organica' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h3 class="widget-title"><span>',
			'after_title' => '</span></h3>',
		) );
		
		register_sidebar( array(
			'name' => esc_html__( 'Shop Sidebar', 'organica' ),
			'id' => 'sidebar-shop',
			'description' => esc_html__( 'Sidebar on shop page (only sidebar shop layout)', 'organica' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h3 class="widget-title"><span>',
			'after_title' => '</span></h3>',
		) );

		register_sidebar( array(
			'name' => __( 'Pages Sidebar', 'organica' ),
			'id' => 'sidebar-page',
			'description' => __( 'Sidebar on content pages', 'organica' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h3 class="widget-title"><span>',
			'after_title' => '</span></h3>',
		) );
		
		if($organica_opt['custom-sidebars']){
			foreach($organica_opt['custom-sidebars'] as $sidebar){
				if($sidebar != '') {
					$sidebar_id = str_replace(' ', '-', strtolower($sidebar));
					register_sidebar( array(
						'name' => $sidebar,
						'id' => $sidebar_id,
						'description' => $sidebar,
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget' => '</aside>',
						'before_title' => '<h3 class="widget-title"><span>',
						'after_title' => '</span></h3>',
					) );
				}
			}
		}
	}
	static function organica_meta_box_callback( $post ) {

		// Add an nonce field so we can check for it later.
		wp_nonce_field( 'organica_meta_box', 'organica_meta_box_nonce' );

		/*
		 * Use get_post_meta() to retrieve an existing value
		 * from the database and use the value for the form.
		 */
		$value = get_post_meta( $post->ID, '_organica_post_intro', true );

		echo '<label for="organica_post_intro">';
		esc_html_e( 'This content will be used to replace the featured image, use shortcode here', 'organica' );
		echo '</label><br />';
		wp_editor( $value, 'organica_post_intro', $settings = array() );
	}
	static function organica_custom_sidebar_callback( $post ) {
		global $wp_registered_sidebars;

		$organica_opt = get_option( 'organica_opt' );

		// Add an nonce field so we can check for it later.
		wp_nonce_field( 'organica_meta_box', 'organica_meta_box_nonce' );

		/*
		 * Use get_post_meta() to retrieve an existing value
		 * from the database and use the value for the form.
		 */

		//show sidebar dropdown select
		$csidebar = get_post_meta( $post->ID, '_organica_custom_sidebar', true );

		echo '<label for="organica_custom_sidebar">';
		esc_html_e( 'Select a custom sidebar for this post/page', 'organica' );
		echo '</label><br />';

		echo '<select id="organica_custom_sidebar" name="organica_custom_sidebar">';
			echo '<option value="">'.esc_html('- None -', 'organica').'</option>';
			foreach($wp_registered_sidebars as $sidebar){
				$sidebar_id = $sidebar['id'];
				if($csidebar == $sidebar_id){
					echo '<option value="'.$sidebar_id.'" selected="selected">'.$sidebar['name'].'</option>';
				} else {
					echo '<option value="'.$sidebar_id.'">'.$sidebar['name'].'</option>';
				}
			}
		echo '</select><br />';

		//show custom sidebar position
		$csidebarpos = get_post_meta( $post->ID, '_organica_custom_sidebar_pos', true );

		echo '<label for="organica_custom_sidebar_pos">';
		esc_html_e( 'Sidebar position', 'organica' );
		echo '</label><br />';

		echo '<select id="organica_custom_sidebar_pos" name="organica_custom_sidebar_pos">'; ?>
			<option value="left" <?php if($csidebarpos == 'left') {echo 'selected="selected"';}?>><?php echo esc_html('Left', 'organica'); ?></option>
			<option value="right" <?php if($csidebarpos == 'right') {echo 'selected="selected"';}?>><?php echo esc_html('Right', 'organica'); ?></option>
		<?php echo '</select>';
	}

	function organica_add_meta_box() {

		$screens = array( 'post', 'page' );

		foreach ( $screens as $screen ) {
			if($screen == 'post'){
				add_meta_box(
					'organica_post_intro_section',
					__( 'Post featured content', 'organica' ),
					'Organica_Class::organica_meta_box_callback',
					$screen
				);
				add_meta_box(
					'organica_custom_sidebar',
					__( 'Custom Sidebar', 'organica' ),
					'Organica_Class::organica_custom_sidebar_callback',
					$screen
				);
			}
			if($screen == 'page'){
				add_meta_box(
					'organica_custom_sidebar',
					__( 'Custom Sidebar', 'organica' ),
					'Organica_Class::organica_custom_sidebar_callback',
					$screen
				);
			}
		}
	}
	function organica_save_meta_box_data( $post_id ) {

		/*
		 * We need to verify this came from our screen and with proper authorization,
		 * because the save_post action can be triggered at other times.
		 */

		// Check if our nonce is set.
		if ( ! isset( $_POST['organica_meta_box_nonce'] ) ) {
			return;
		}

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $_POST['organica_meta_box_nonce'], 'organica_meta_box' ) ) {
			return;
		}

		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}

		} else {

			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}

		/* OK, it's safe for us to save the data now. */
		
		// Make sure that it is set.
		if ( ! ( isset( $_POST['organica_post_intro'] ) || isset( $_POST['organica_custom_sidebar'] ) ) )  {
			return;
		}

		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['organica_post_intro'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, '_organica_post_intro', $my_data );

		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['organica_custom_sidebar'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, '_organica_custom_sidebar', $my_data );

		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['organica_custom_sidebar_pos'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, '_organica_custom_sidebar_pos', $my_data );
		
	}
	//Change comment form
	function organica_before_comment_fields() {
		echo '<div class="comment-input">';
	}
	function organica_after_comment_fields() {
		echo '</div>';
	}
	/**
	 * Register postMessage support.
	 *
	 * Add postMessage support for site title and description for the Customizer.
	 *
	 * @since Huge Shop 1.0
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer object.
	 */
	function organica_customize_register( $wp_customize ) {
		$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
		$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
		$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	}
	/**
	 * Enqueue Javascript postMessage handlers for the Customizer.
	 *
	 * Binds JS handlers to make the Customizer preview reload changes asynchronously.
	 *
	 * @since Huge Shop 1.0
	 */
	function organica_customize_preview_js() {
		wp_enqueue_script( 'organica-customizer', get_template_directory_uri() . '/js/theme-customizer.js', array( 'customize-preview' ), '20130301', true );
	}
	// Remove Redux Ads
	function organica_remove_redux_ads() { ?>
	<style type="text/css">
	.rAds, .redux-messageredux-notice {
		display: none !important;
	}
	</style>
	<?php
	}
	/**
	* Utility methods
	* ---------------
	*/
	
	//Add breadcrumbs
	static function organica_breadcrumb() {
		global $post;

		$organica_opt = get_option( 'organica_opt' );
		
		$brseparator = '<span class="separator">/</span>';
		if (!is_home()) {
			echo '<div class="breadcrumbs">';
			
			echo '<a href="';
			echo esc_url( home_url( '/' ));
			echo '">';
			echo esc_html('Home', 'organica');
			echo '</a>'.$brseparator;
			if (is_category() || is_single()) {
				the_category($brseparator);
				if (is_single()) {
					echo ''.$brseparator;
					the_title();
				}
			} elseif (is_page()) {
				if($post->post_parent){
					$anc = get_post_ancestors( $post->ID );
					$title = get_the_title();
					foreach ( $anc as $ancestor ) {
						$output = '<a href="'.get_permalink($ancestor).'" title="'.get_the_title($ancestor).'">'.get_the_title($ancestor).'</a>'.$brseparator;
					}
					echo wp_kses($output, array(
							'a'=>array(
								'href' => array(),
								'title' => array()
							),
							'span'=>array(
								'class'=>array()
							)
						)
					);
					echo '<span title="'.$title.'"> '.$title.'</span>';
				} else {
					echo '<span> '.get_the_title().'</span>';
				}
			}
			elseif (is_tag()) {single_tag_title();}
			elseif (is_day()) {echo "<span>".esc_html__('Archive for','organica'); the_time('F jS, Y'); echo'</span>';}
			elseif (is_month()) {echo "<span>".esc_html__('Archive for','organica'); the_time('F, Y'); echo'</span>';}
			elseif (is_year()) {echo "<span>".esc_html__('Archive for','organica'); the_time('Y'); echo'</span>';}
			elseif (is_author()) {echo "<span>".esc_html__('Archive for','organica'); echo'</span>';}
			elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<span>".esc_html__('Blog Archives','organica'); echo'</span>';}
			elseif (is_search()) {echo "<span>".esc_html__('Search Results','organica'); echo'</span>';}
			
			echo '</div>';
		} else {
			echo '<div class="breadcrumbs">';
			
			echo '<a href="';
			echo esc_url( home_url( '/' ) );
			echo '">';
			echo esc_html('Home', 'organica');
			echo '</a>'.$brseparator;
			
			if(isset($organica_opt['blog_header_text']) && $organica_opt['blog_header_text']!=""){
				echo esc_html($organica_opt['blog_header_text']);
			} else {
				echo esc_html('Blog', 'organica');
			}
			
			echo '</div>';
		}
	}
	static function organica_limitStringByWord ($string, $maxlength, $suffix = '') {

		if(function_exists( 'mb_strlen' )) {
			// use multibyte functions by Iysov
			if(mb_strlen( $string )<=$maxlength) return $string;
			$string = mb_substr( $string, 0, $maxlength );
			$index = mb_strrpos( $string, ' ' );
			if($index === FALSE) {
				return $string;
			} else {
				return mb_substr( $string, 0, $index ).$suffix;
			}
		} else { // original code here
			if(strlen( $string )<=$maxlength) return $string;
			$string = substr( $string, 0, $maxlength );
			$index = strrpos( $string, ' ' );
			if($index === FALSE) {
				return $string;
			} else {
				return substr( $string, 0, $index ).$suffix;
			}
		}
	}
	static function organica_excerpt_by_id($post, $length = 10, $tags = '<a><em><strong>') {
 
		if(is_int($post)) {
			// get the post object of the passed ID
			$post = get_post($post);
		} elseif(!is_object($post)) {
			return false;
		}
	 
		if(has_excerpt($post->ID)) {
			$the_excerpt = $post->post_excerpt;
			return apply_filters('the_content', $the_excerpt);
		} else {
			$the_excerpt = $post->post_content;
		}
	 
		$the_excerpt = strip_shortcodes(strip_tags($the_excerpt), $tags);
		$the_excerpt = preg_split('/\b/', $the_excerpt, $length * 2+1);
		$excerpt_waste = array_pop($the_excerpt);
		$the_excerpt = implode($the_excerpt);
	 
		return apply_filters('the_content', $the_excerpt);
	}
	/**
	 * Return the Google font stylesheet URL if available.
	 *
	 * The use of Open Sans by default is localized. For languages that use
	 * characters not supported by the font, the font can be disabled.
	 *
	 * @since Huge Shop 1.2
	 *
	 * @return string Font stylesheet or empty string if disabled.
	 */
	function organica_get_font_url() {
		$font_url = '';

		/* translators: If there are characters in your language that are not supported
		 * by Open Sans, translate this to 'off'. Do not translate into your own language.
		 */
		if ( 'off' !== _x( 'on', 'Open Sans font: on or off', 'organica' ) ) {
			$subsets = 'latin,latin-ext';

			/* translators: To add an additional Open Sans character subset specific to your language,
			 * translate this to 'greek', 'cyrillic' or 'vietnamese'. Do not translate into your own language.
			 */
			$subset = _x( 'no-subset', 'Open Sans font: add new subset (greek, cyrillic, vietnamese)', 'organica' );

			if ( 'cyrillic' == $subset )
				$subsets .= ',cyrillic,cyrillic-ext';
			elseif ( 'greek' == $subset )
				$subsets .= ',greek,greek-ext';
			elseif ( 'vietnamese' == $subset )
				$subsets .= ',vietnamese';

			$protocol = is_ssl() ? 'https' : 'http';
			$query_args = array(
				'family' => 'Open+Sans:400italic,700italic,400,700',
				'subset' => $subsets,
			);
			$font_url = add_query_arg( $query_args, "$protocol://fonts.googleapis.com/css" );
		}

		return $font_url;
	}
	/**
	 * Displays navigation to next/previous pages when applicable.
	 *
	 * @since Huge Shop 1.0
	 */
	static function organica_content_nav( $html_id ) {
		global $wp_query;

		$html_id = esc_attr( $html_id );

		if ( $wp_query->max_num_pages > 1 ) : ?>
			<nav id="<?php echo esc_attr($html_id); ?>" class="navigation" role="navigation">
				<h3 class="assistive-text"><?php esc_html_e( 'Post navigation', 'organica' ); ?></h3>
				<div class="nav-previous"><?php next_posts_link( wp_kses(__( '<span class="meta-nav">&larr;</span> Older posts', 'organica' ),array('span'=>array('class'=>array())) )); ?></div>
				<div class="nav-next"><?php previous_posts_link( wp_kses(__( 'Newer posts <span class="meta-nav">&rarr;</span>', 'organica' ), array('span'=>array('class'=>array())) )); ?></div>
			</nav>
		<?php endif;
	}
	/* Pagination */
	static function organica_pagination() {
		global $wp_query;

		$big = 999999999; // need an unlikely integer
		
		echo paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $wp_query->max_num_pages,
			'prev_text'    => esc_html__('Previous', 'organica'),
			'next_text'    =>esc_html__('Next', 'organica'),
		) );
	}
	/**
	 * Template for comments and pingbacks.
	 *
	 * To override this walker in a child theme without modifying the comments template
	 * simply create your own organica_comment(), and that function will be used instead.
	 *
	 * Used as a callback by wp_list_comments() for displaying the comments.
	 *
	 * @since Huge Shop 1.0
	 */
	static function organica_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
			// Display trackbacks differently than normal comments.
		?>
		<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
			<p><?php esc_html_e( 'Pingback:', 'organica' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( esc_html__( '(Edit)', 'organica' ), '<span class="edit-link">', '</span>' ); ?></p>
		<?php
				break;
			default :
			// Proceed with normal comments.
			global $post;
		?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
			<article id="comment-<?php comment_ID(); ?>" class="comment">
				<div class="comment-avatar">
					<?php echo get_avatar( $comment, 50 ); ?>
				</div>
				<div class="comment-info">
					<header class="comment-meta comment-author vcard">
						<?php
							
							printf( '<cite><b class="fn">%1$s</b> %2$s</cite>',
								get_comment_author_link(),
								// If current post author is also comment author, make it known visually.
								( $comment->user_id === $post->post_author ) ? '<span>' . esc_html__( 'Post author', 'organica' ) . '</span>' : ''
							);
							printf( '<time datetime="%1$s">%2$s</time>',
								get_comment_time( 'c' ),
								/* translators: 1: date, 2: time */
								sprintf( esc_html__( '%1$s at %2$s', 'organica' ), get_comment_date(), get_comment_time() )
							);
						?>
						<div class="reply">
							<?php comment_reply_link( array_merge( $args, array( 'reply_text' => esc_html__( 'Reply', 'organica' ), 'after' => '', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
						</div><!-- .reply -->
					</header><!-- .comment-meta -->
					<?php if ( '0' == $comment->comment_approved ) : ?>
						<p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'organica' ); ?></p>
					<?php endif; ?>

					<section class="comment-content comment">
						<?php comment_text(); ?>
						<?php edit_comment_link( esc_html__( 'Edit', 'organica' ), '<p class="edit-link">', '</p>' ); ?>
					</section><!-- .comment-content -->
				</div>
			</article><!-- #comment-## -->
		<?php
			break;
		endswitch; // end comment_type check
	}
	/**
	 * Set up post entry meta.
	 *
	 * Prints HTML with meta information for current post: categories, tags, permalink, author, and date.
	 *
	 * Create your own organica_entry_meta() to override in a child theme.
	 *
	 * @since Huge Shop 1.0
	 */
	static function organica_entry_meta() {
		
		// Translators: used between list items, there is a space after the comma.
		$tag_list = get_the_tag_list( '', ', ' );

		$num_comments = (int)get_comments_number();
		$write_comments = '';
		if ( comments_open() ) {
			if ( $num_comments == 0 ) {
				$comments = esc_html__('0 comments', 'organica');
			} elseif ( $num_comments > 1 ) {
				$comments = $num_comments . esc_html__(' comments', 'organica');
			} else {
				$comments = esc_html__('1 comment', 'organica');
			}
			$write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
		}

		$utility_text = esc_html__( '%1$s / Tags: %2$s', 'organica' );

		printf( $utility_text, $write_comments, $tag_list);
	}
	static function organica_entry_meta_small() {
		
		// Translators: used between list items, there is a space after the comma.
		$categories_list = get_the_category_list(', ');

		$author = sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_attr( sprintf( wp_kses(__( 'View all posts by %s', 'organica' ), array('a'=>array())), get_the_author() ) ),
			get_the_author()
		);
		
		$utility_text = esc_html__( 'Posted by %1$s / %2$s', 'organica' );

		printf( $utility_text, $author, $categories_list );
		
	}
	static function organica_entry_comments() {
		
		$date = sprintf( '<time class="entry-date" datetime="%3$s">%4$s</time>',
			esc_url( get_permalink() ),
			esc_attr( get_the_time() ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() )
		);

		$num_comments = (int)get_comments_number();
		$write_comments = '';
		if ( comments_open() ) {
			if ( $num_comments == 0 ) {
				$comments = wp_kses(__('<span>0</span> comments', 'organica'), array('span'=>array()));
			} elseif ( $num_comments > 1 ) {
				$comments = '<span>'.$num_comments .'</span>'. esc_html__(' comments', 'organica');
			} else {
				$comments = wp_kses(__('<span>1</span> comment', 'organica'), array('span'=>array()));
			}
			$write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
		}
		
		$utility_text = esc_html__( '%1$s', 'organica' );
		
		printf( $utility_text, $write_comments );
	}
	/**
	* TGM-Plugin-Activation
	*/
	function organica_register_required_plugins() {

		$plugins = array(
			array(
				'name'               => esc_html__('Roadthemes Helper', 'organica'),
				'slug'               => 'roadthemes-helper',
				'source'             => get_template_directory() . '/plugins/roadthemes-helper.zip',
				'required'           => true,
				'version'            => '1.0.0',
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => '',
			),
			array(
				'name'               => esc_html__('Mega Main Menu', 'organica'),
				'slug'               => 'mega_main_menu',
				'source'             => PLUGIN_REQUIRED_PATH . '/mega_main_menu.zip',
				'required'           => true,
				'external_url'       => '',
			),
			array(
				'name'               => esc_html__('Revolution Slider', 'organica'),
				'slug'               => 'revslider',
				'source'             => PLUGIN_REQUIRED_PATH . '/revslider.zip',
				'required'           => true,
				'external_url'       => '',
			),
			array(
				'name'               => esc_html__('Import Sample Data', 'organica'),
				'slug'               => 'road-importdata',
				'source'             => get_template_directory() . '/plugins/road-importdata.zip',
				'required'           => true,
				'external_url'       => '',
			),
			array(
				'name'               => esc_html__('Visual Composer', 'organica'),
				'slug'               => 'js_composer',
				'source'             => PLUGIN_REQUIRED_PATH . '/js_composer.zip',
				'required'           => true,
				'external_url'       => '',
			),
			array(
				'name'               => esc_html__('Templatera', 'organica'),
				'slug'               => 'templatera',
				'source'             => PLUGIN_REQUIRED_PATH . '/templatera.zip',
				'required'           => true,
				'external_url'       => '',
			),
			array(
				'name'               => esc_html__('Essential Grid', 'organica'),
				'slug'               => 'essential-grid',
				'source'             => PLUGIN_REQUIRED_PATH . '/essential-grid.zip',
				'required'           => true,
				'external_url'       => '',
			),
			array(
				'name'      => esc_html__('Testimonials', 'organica'),
				'slug'      => 'testimonials-by-woothemes',
				'source'             => PLUGIN_REQUIRED_PATH . '/testimonials-by-woothemes.zip',
				'required'  => true,
			),
			// Plugins from the WordPress Plugin Repository.
			array(
				'name'               => esc_html__('Redux Framework', 'organica'),
				'slug'               => 'redux-framework',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false,
			),
			array(
				'name'      => esc_html__('Contact Form 7', 'organica'),
				'slug'      => 'contact-form-7',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('Events Manager', 'organica'),
				'slug'      => 'events-manager',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Instagram Feed', 'organica'),
				'slug'      => 'instagram-feed',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Latest Tweets Widget', 'organica'),
				'slug'      => 'latest-tweets-widget',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('WS Facebook Like Box Widget', 'organica'),
				'slug'      => 'ws-facebook-likebox',
				'required'  => false,
			),
			// array(
			// 	'name'      => 'MailPoet Newsletters',
			// 	'slug'      => 'wysija-newsletters',
			// 	'required'  => true,
			// ),
			array(
				'name'      => esc_html__('MailChimp for WordPress', 'organica'),
				'slug'      => 'mailchimp-for-wp',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('Shortcodes Ultimate', 'organica'),
				'slug'      => 'shortcodes-ultimate',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('Simple Local Avatars', 'organica'),
				'slug'      => 'simple-local-avatars',
				'required'  => false,
			),
			
			array(
				'name'      => esc_html__('TinyMCE Advanced', 'organica'),
				'slug'      => 'tinymce-advanced',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Widget Importer & Exporter', 'organica'),
				'slug'      => 'widget-importer-exporter',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('WooCommerce', 'organica'),
				'slug'      => 'woocommerce',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('YITH WooCommerce Compare', 'organica'),
				'slug'      => 'yith-woocommerce-compare',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('YITH WooCommerce Wishlist', 'organica'),
				'slug'      => 'yith-woocommerce-wishlist',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('YITH WooCommerce Zoom Magnifier', 'organica'),
				'slug'      => 'yith-woocommerce-zoom-magnifier',
				'required'  => false,
			),
		);

		/**
		 * Array of configuration settings. Amend each line as needed.
		 * If you want the default strings to be available under your own theme domain,
		 * leave the strings uncommented.
		 * Some of the strings are added into a sprintf, so see the comments at the
		 * end of each line for what each argument will be.
		 */
		$config = array(
			'default_path' => '',                      // Default absolute path to pre-packaged plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
			'strings'      => array(
				'page_title'                      => esc_html__( 'Install Required Plugins', 'organica' ),
				'menu_title'                      => esc_html__( 'Install Plugins', 'organica' ),
				'installing'                      => esc_html__( 'Installing Plugin: %s', 'organica' ), // %s = plugin name.
				'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'organica' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'organica' ), // %1$s = plugin name(s).
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'organica' ), // %1$s = plugin name(s).
				'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'organica' ), // %1$s = plugin name(s).
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'organica' ), // %1$s = plugin name(s).
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'organica' ), // %1$s = plugin name(s).
				'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'organica' ), // %1$s = plugin name(s).
				'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'organica' ), // %1$s = plugin name(s).
				'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'organica' ), // %1$s = plugin name(s).
				'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'organica' ),
				'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'organica' ),
				'return'                          => esc_html__( 'Return to Required Plugins Installer', 'organica' ),
				'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'organica' ),
				'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'organica' ), // %s = dashboard link.
				'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
			)
		);

		tgmpa( $plugins, $config );

	}
}

// Instantiate theme
$Organica_Class = new Organica_Class();

//Fix duplicate id of mega menu
function organica_mega_menu_id_change($params) {
	ob_start('organica_mega_menu_id_change_call_back');
}
function organica_mega_menu_id_change_call_back($html){
	$html = preg_replace('/id="mega_main_menu"/', 'id="mega_main_menu_first"', $html, 1);
	$html = preg_replace('/id="mega_main_menu_ul"/', 'id="mega_main_menu_ul_first"', $html, 1);
	
	return $html;
}
add_action('wp_loaded', 'organica_mega_menu_id_change');