<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

get_header( 'shop' ); ?>

<div class="main-container">

	<div class="page-content">
	
		<div class="product-page">
			<div class="title-breadcrumb">
				<div class="container">
					<div class="title-breadcrumb-inner">          
						<header class="entry-header">
							<h1 class="entry-title"><?php echo esc_html__('single product', 'konado'); ?></h1>
						</header>     
						<?php do_action( 'woocommerce_before_main_content' ); ?>
					</div>
				</div>
			</div>
			<div class="product-view">
				<?php while ( have_posts() ) : the_post(); ?>

					<?php wc_get_template_part( 'content', 'single-product' ); ?>

				<?php endwhile; // end of the loop. ?>

				<?php
					/**
					 * woocommerce_after_main_content hook
					 *
					 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
					 */
					do_action( 'woocommerce_after_main_content' );
				?>

				<?php
					/**
					 * woocommerce_sidebar hook
					 *
					 * @hooked woocommerce_get_sidebar - 10
					 */
					//do_action( 'woocommerce_sidebar' );
				?> 
			</div> 
		</div> 
	</div>
</div>
<?php get_footer( 'shop' ); ?>