<?php 

if( ! function_exists( 'road_get_slider_setting' ) ) {
	function road_get_slider_setting() {
		$status_opt = array(
			'',
			__( 'Yes', 'konado' ) => true,
			__( 'No', 'konado' ) => false,
		);
		
		$effect_opt = array(
			'',
			__( 'Fade', 'konado' ) => 'fade',
			__( 'Slide', 'konado' ) => 'slide',
		);
	 
		return array( 
			array(
				'type' => 'checkbox',
				'heading' => __( 'Enable slider', 'konado' ),
				'param_name' => 'enable_slider',
				'value' => true,
				'save_always' => true, 
				'group' => __( 'Slider Options', 'konado' ),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Items Large Screen', 'konado' ),
				'param_name' => 'item_large',
				'group' => __( 'Slider Options', 'konado' ),
				'value' => 6,
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Items Default', 'konado' ),
				'param_name' => 'items',
				'group' => __( 'Slider Options', 'konado' ),
				'value' => 5,
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Item Desktop', 'konado' ),
				'param_name' => 'item_desktop',
				'group' => __( 'Slider Options', 'konado' ),
				'value' => 4,
			), 
			array(
				'type' => 'textfield',
				'heading' => __( 'Item Small', 'konado' ),
				'param_name' => 'item_small',
				'group' => __( 'Slider Options', 'konado' ),
				'value' => 3,
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Item Tablet', 'konado' ),
				'param_name' => 'item_tablet',
				'group' => __( 'Slider Options', 'konado' ),
				'value' => 2,
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Item Mobile', 'konado' ),
				'param_name' => 'item_mobile',
				'group' => __( 'Slider Options', 'konado' ),
				'value' => 1,
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Navigation', 'konado' ),
				'param_name' => 'navigation',
				'value' => $status_opt,
				'save_always' => true,
				'group' => __( 'Slider Options', 'konado' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Pagination', 'konado' ),
				'param_name' => 'pagination',
				'value' => $status_opt,
				'save_always' => true,
				'group' => __( 'Slider Options', 'konado' )
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Speed sider', 'konado' ),
				'param_name' => 'speed',
				'value' => '500',
				'save_always' => true,
				'group' => __( 'Slider Options', 'konado' )
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Slider Auto', 'konado' ),
				'param_name' => 'auto',
				'value' => false, 
				'group' => __( 'Slider Options', 'konado' )
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Slider loop', 'konado' ),
				'param_name' => 'loop',
				'value' => false, 
				'group' => __( 'Slider Options', 'konado' )
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Slider center', 'konado' ),
				'param_name' => 'center',
				'value' => false, 
				'dependency' => array(
				    'element' => 'loop',
				    'value' => array ('true'),
				    'not_empty' => true,
				),
				'group' => __( 'Slider Options', 'konado' )
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Effects', 'konado' ),
				'param_name' => 'effect',
				'value' => $effect_opt,
				'save_always' => true,
				'group' => __( 'Slider Options', 'konado' )
			), 
		);
	}
}