<?php
/* Instagram Widget support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('organics_instagram_widget_theme_setup')) {
	add_action( 'organics_action_before_init_theme', 'organics_instagram_widget_theme_setup', 1 );
	function organics_instagram_widget_theme_setup() {
		if (is_admin()) {
			add_filter( 'organics_filter_importer_required_plugins',		'organics_instagram_widget_importer_required_plugins', 10, 2 );
			add_filter( 'organics_filter_required_plugins',					'organics_instagram_widget_required_plugins' );
		}
	}
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'organics_exists_instagram_widget' ) ) {
	function organics_exists_instagram_widget() {
		return organics_widget_is_active('wp-instagram-widget/wp-instagram-widget');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'organics_instagram_widget_required_plugins' ) ) {
	//add_filter('organics_filter_required_plugins',	'organics_instagram_widget_required_plugins');
	function organics_instagram_widget_required_plugins($list=array()) {
		$list[] = array(
					'name' 		=> 'Instagram Widget',
					'slug' 		=> 'wp-instagram-widget',
					'required' 	=> false
				);
		return $list;
	}
}



// One-click import support
//------------------------------------------------------------------------

// Check Instagram Widget in the required plugins
if ( !function_exists( 'organics_instagram_widget_importer_required_plugins' ) ) {
	//add_filter( 'organics_filter_importer_required_plugins',	'organics_instagram_widget_importer_required_plugins', 10, 2 );
	function organics_instagram_widget_importer_required_plugins($not_installed='', $importer=null) {
		if ($importer && in_array('instagram_widget', $importer->options['required_plugins']) && !organics_exists_instagram_widget() )
			$not_installed .= '<br>WP Instagram Widget';
		return $not_installed;
	}
}
?>